# Local SMTP Server Setup for Windows

## **Method 1: Mercury Mail Server (Free)**

### Step 1: Download and Install Mercury Mail
1. Download Mercury Mail from: https://www.pmail.com/overviews/ovw_mercury.htm
2. Install Mercury Mail to `C:\Mercury`
3. Run Mercury Mail as Administrator

### Step 2: Configure Mercury Mail
1. **Core Module Settings**:
   - Local host name: `localhost`
   - Internet name: `your-domain.com` (or use localhost)
   - Check "NetWare server" (if needed)

2. **SMTP Server Settings**:
   - Enable SMTP server on port 25
   - Allow relay for local connections
   - Set maximum message size (default: 10MB)

3. **Configuration Steps**:
   ```
   Configuration → Core Module
   - Local host name: localhost
   - Internet name for mail: localhost
   
   Configuration → Protocol Modules → SMTP Server
   - Listen on TCP/IP port: 25
   - Session timeout: 600 seconds
   - Allow SMTP relaying by local users: ✓
   ```

### Step 3: Configure POS System
- **SMTP Host**: `localhost`
- **SMTP Port**: `25`
- **SMTP Username**: *(leave empty)*
- **SMTP Password**: *(leave empty)*
- **SMTP Encryption**: `None`

---

## **Method 2: hMailServer (Free - Recommended)**

### Step 1: Download and Install hMailServer
1. Download from: https://www.hmailserver.com/download
2. Install with full installation
3. Choose "Use built-in database engine"
4. Set administrator password during installation

### Step 2: Configure hMailServer
1. **Open hMailServer Administrator**
2. **Create Domain**:
   - Right-click "Domains" → Add Domain
   - Domain name: `localhost` or `yourdomain.com`

3. **Create Email Account**:
   - Expand domain → Right-click "Accounts" → Add
   - Address: `admin@localhost`
   - Password: Set a password

4. **SMTP Settings**:
   - Settings → Protocols → SMTP
   - Port: 25 (or 587 for TLS)
   - Enable "Allow SMTP authentication"
   - Security: None (for local testing)

### Step 3: Configure POS System
- **SMTP Host**: `localhost`
- **SMTP Port**: `25` (or `587`)
- **SMTP Username**: `admin@localhost`
- **SMTP Password**: *(password you set)*
- **SMTP Encryption**: `None` (or `TLS` if using port 587)

---

## **Method 3: Using IIS SMTP (Windows Server/Pro)**

### Step 1: Install SMTP Feature
1. Open "Turn Windows features on or off"
2. Enable "Internet Information Services"
3. Enable "SMTP Server" under IIS features

### Step 2: Configure IIS SMTP
1. Open IIS Manager
2. Configure SMTP Virtual Server:
   - Right-click → Properties
   - Access → Authentication: Anonymous access
   - Delivery → Outbound connections: Port 25

### Step 3: Configure POS System
- **SMTP Host**: `localhost`
- **SMTP Port**: `25`
- **SMTP Username**: *(leave empty)*
- **SMTP Password**: *(leave empty)*
- **SMTP Encryption**: `None`

---

## **Method 4: MailHog (For Testing)**

### Step 1: Download MailHog
1. Download from: https://github.com/mailhog/MailHog/releases
2. Extract `MailHog.exe` to a folder
3. Run `MailHog.exe`

### Step 2: Configure
- MailHog runs on port 1025 for SMTP
- Web interface: http://localhost:8025
- Captures all emails (doesn't actually send them)

### Step 3: Configure POS System
- **SMTP Host**: `localhost`
- **SMTP Port**: `1025`
- **SMTP Username**: *(leave empty)*
- **SMTP Password**: *(leave empty)*
- **SMTP Encryption**: `None`

---

## **PHP Configuration Requirements**

### Check php.ini Settings
```ini
; Ensure these extensions are enabled
extension=openssl
extension=curl
extension=sockets

; SMTP settings (for mail() function - not needed for PHPMailer)
SMTP = localhost
smtp_port = 25
sendmail_from = admin@localhost

; Error reporting
log_errors = On
error_log = "C:\xampp\php\logs\php_error_log"
```

### Restart Apache
After changing php.ini, restart Apache in XAMPP Control Panel.

---

## **Firewall Configuration**

### Windows Firewall
1. Open Windows Firewall
2. Click "Allow an app or feature through Windows Firewall"
3. Add exceptions for:
   - Mercury Mail (if using)
   - hMailServer (if using)
   - Apache (XAMPP)
   - Ports: 25, 587, 993, 995

---

## **Testing Your Setup**

### Using POS System
1. Go to Settings → Email Settings
2. Configure your chosen SMTP method
3. Click "Test Email Configuration"
4. Check the test email address

### Using Command Line (Telnet)
```cmd
telnet localhost 25
HELO localhost
MAIL FROM: test@localhost
RCPT TO: admin@localhost
DATA
Subject: Test Email

This is a test email.
.
QUIT
```

---

## **Troubleshooting**

### Common Issues:
1. **Port 25 blocked**: Try port 587 or 2525
2. **Antivirus blocking**: Add SMTP server to exclusions
3. **Firewall blocking**: Configure Windows Firewall
4. **Authentication errors**: Check username/password
5. **Connection timeout**: Ensure SMTP server is running

### Debug Steps:
1. Check if SMTP server is running
2. Test with telnet
3. Check Windows Event Logs
4. Enable PHP error logging
5. Check SMTP server logs

---

## **Security Considerations**

### For Production:
1. **Enable Authentication**: Always require SMTP authentication
2. **Use TLS/SSL**: Encrypt email transmission
3. **Restrict Access**: Limit SMTP relay to localhost only
4. **Strong Passwords**: Use complex passwords for email accounts
5. **Firewall Rules**: Block external access to SMTP ports

### Recommended Production Settings:
- **Port**: 587 (with TLS)
- **Authentication**: Required
- **Encryption**: TLS
- **Relay**: Localhost only 